/*
 * Decompiled with CFR 0.152.
 */
package jtbcore.setting;

import java.io.File;
import java.io.IOException;
import jtbcore.util.NumberUtil;
import org.ini4j.Ini;
import org.ini4j.Profile;

public class IniParser {
    protected File file = null;
    protected Ini ini = null;

    public IniParser(String path) {
        this.file = new File(path);
    }

    public IniParser(File f) {
        this.file = f;
    }

    public void load() {
        this.ini = new Ini();
        if (this.file != null) {
            try {
                this.ini.load(this.file);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void set(String sectionName, String key, Object val) {
        Profile.Section s = (Profile.Section)this.ini.get((Object)sectionName);
        if (s == null) {
            s = this.ini.add(sectionName);
        }
        s.put(key, val);
    }

    public String get(String sectionName, String key) {
        Profile.Section s = (Profile.Section)this.ini.get((Object)sectionName);
        if (s == null) {
            return null;
        }
        return (String)s.get((Object)key);
    }

    public String get(String sectionName, String key, String defaultValue) {
        String r = this.get(sectionName, key);
        if (r == null) {
            r = defaultValue;
        }
        return r;
    }

    public Integer getInt(String sectionName, String key) {
        return NumberUtil.tryParseInt(this.get(sectionName, key));
    }

    public Integer getInt(String sectionName, String key, Integer defaultValue) {
        Integer r = this.getInt(sectionName, key);
        if (r == null) {
            r = defaultValue;
        }
        return r;
    }

    public Boolean getBool(String sectionName, String key, Boolean defaultValue) {
        String s = this.get(sectionName, key);
        if (s == null) {
            return defaultValue;
        }
        if ("1".equals(s) || "true".equalsIgnoreCase(s) || "t".equalsIgnoreCase(s)) {
            return true;
        }
        return false;
    }

    public void save() throws IOException {
        this.ini.store(this.file);
    }

    public void saveIfNew() throws IOException {
        if (this.file != null && !this.file.exists()) {
            this.ini.store(this.file);
        }
    }

    public static void main(String[] args) {
        try {
            IniParser p = new IniParser("C:/tmp/test.ini");
            p.load();
            p.set("root", "port", 1234);
            p.save();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

